capture log close

cd "F:\UserData\Hemmeter\SBST"
set more off
set logtype text
set seed 1234567890

	
log using "SSI Letters Data Prep Month 24 $S_DATE", replace

	
/*Compress data to save memory--only need to do this once*/
		/*
use outcomes06012022, clear
compress
save outcomes06012022a, replace
	*/

/*remove duplicates*/
	use outcomes06012022a, clear
	bysort boan: egen applied_earliest=min(appl_jd)
	bysort boan: egen awarded_earliest=min(first_pay_date)

	duplicates drop boan, force 
	isid boan

	gen applied3=(applied_earliest <= mdy(12,31,2017))
	gen applied6=(applied_earliest <= mdy(3,31,2018))
	gen applied9=(applied_earliest <= mdy(6,30,2018))
	gen applied12=(applied_earliest <= mdy(9,30,2018))
	gen applied15=(applied_earliest <= mdy(12,31,2018))
	gen applied18=(applied_earliest <= mdy(3,31,2019))
	gen applied21=(applied_earliest <= mdy(6,30,2019))
	gen applied24=(applied_earliest <= mdy(9,30,2019))

	gen awarded3=(awarded_earliest <= mdy(12,31,2017))
	gen awarded6=(awarded_earliest <= mdy(3,31,2018))
	gen awarded9=(awarded_earliest <= mdy(6,30,2018))
	gen awarded12=(awarded_earliest <= mdy(9,30,2018))
	gen awarded15=(awarded_earliest <= mdy(12,31,2018))
	gen awarded18=(awarded_earliest <= mdy(3,31,2019))
	gen awarded21=(awarded_earliest <= mdy(6,30,2019))
	gen awarded24=(awarded_earliest <= mdy(9,30,2019))


/*Create secondary outcomes*/
	/*create variables with 0s as missings*/
	forvalues x = 525(1)588 {
		gen fedpmt_`x'_0=fedpmt_`x' if fedpmt_`x'~=0 & fedpmt_`x'~=.
	}

	
	egen totssi3=rowtotal(fedpmt_526_0 fedpmt_527_0 fedpmt_528_0 )
	egen totssimiss3=rowtotal(fedpmt_526_0 fedpmt_527_0 fedpmt_528_0 ), missing

	gen anyssi3=(totssi3>0)
	gen anyssimiss3=(totssi3>0) if !missing(totssimiss3)
	
	egen avessi3=rowmean(fedpmt_526_0 fedpmt_527_0 fedpmt_528_0 )
	
	egen numssi3=rownonmiss(fedpmt_526_0 fedpmt_527_0 fedpmt_528_0 )
	gen numssimiss3=numssi3 if numssi3~=0	
	

	egen totssi6=rowtotal(fedpmt_526_0 fedpmt_527_0 fedpmt_528_0 fedpmt_529_0 fedpmt_530_0 fedpmt_531_0 )
	egen totssimiss6=rowtotal(fedpmt_526_0 fedpmt_527_0 fedpmt_528_0 fedpmt_529_0 fedpmt_530_0 fedpmt_531_0 ), missing

	gen anyssi6=(totssi6>0)
	gen anyssimiss6=(totssi6>0) if !missing(totssimiss6)
	
	egen avessi6=rowmean(fedpmt_526_0 fedpmt_527_0 fedpmt_528_0 fedpmt_529_0 fedpmt_530_0 fedpmt_531_0 )
	
	egen numssi6=rownonmiss(fedpmt_526_0 fedpmt_527_0 fedpmt_528_0 fedpmt_529_0 fedpmt_530_0 fedpmt_531_0 )
	gen numssimiss6=numssi6 if numssi6~=0	
	
	
	egen totssi9=rowtotal(fedpmt_526_0 fedpmt_527_0 fedpmt_528_0 fedpmt_529_0 fedpmt_530_0 fedpmt_531_0 fedpmt_532_0 fedpmt_533_0 fedpmt_534_0)
	egen totssimiss9=rowtotal(fedpmt_526_0 fedpmt_527_0 fedpmt_528_0 fedpmt_529_0 fedpmt_530_0 fedpmt_531_0 fedpmt_532_0 fedpmt_533_0 fedpmt_534_0), missing

	gen anyssi9=(totssi9>0)
	gen anyssimiss9=(totssi9>0) if !missing(totssimiss9)
	
	egen avessi9=rowmean(fedpmt_526_0 fedpmt_527_0 fedpmt_528_0 fedpmt_529_0 fedpmt_530_0 fedpmt_531_0 fedpmt_532_0 fedpmt_533_0 fedpmt_534_0)
	
	egen numssi9=rownonmiss(fedpmt_526_0 fedpmt_527_0 fedpmt_528_0 fedpmt_529_0 fedpmt_530_0 fedpmt_531_0 fedpmt_532_0 fedpmt_533_0 fedpmt_534_0)
	gen numssimiss9=numssi9 if numssi9~=0



	egen totssi12=rowtotal(fedpmt_526_0-fedpmt_537_0)
	egen totssimiss12=rowtotal(fedpmt_526_0-fedpmt_537_0), missing

	gen anyssi12=(totssi12>0)
	gen anyssimiss12=(totssi12>0) if !missing(totssimiss12)
	
	egen avessi12=rowmean(fedpmt_526_0-fedpmt_537_0)
	
	egen numssi12=rownonmiss(fedpmt_526_0-fedpmt_537_0)
	gen numssimiss12=numssi12 if numssi12~=0

		
	egen totssi15=rowtotal(fedpmt_526_0-fedpmt_540_0)
	egen totssimiss15=rowtotal(fedpmt_526_0-fedpmt_540_0), missing

	gen anyssi15=(totssi15>0)
	gen anyssimiss15=(totssi15>0) if !missing(totssimiss15)
	
	egen avessi15=rowmean(fedpmt_526_0-fedpmt_540_0)
	
	egen numssi15=rownonmiss(fedpmt_526_0-fedpmt_540_0)
	gen numssimiss15=numssi15 if numssi15~=0

			
	egen totssi18=rowtotal(fedpmt_526_0-fedpmt_543_0)
	egen totssimiss18=rowtotal(fedpmt_526_0-fedpmt_543_0), missing

	gen anyssi18=(totssi18>0)
	gen anyssimiss18=(totssi18>0) if !missing(totssimiss18)
	
	egen avessi18=rowmean(fedpmt_526_0-fedpmt_543_0)
	
	egen numssi18=rownonmiss(fedpmt_526_0-fedpmt_543_0)
	gen numssimiss18=numssi18 if numssi18~=0

		
	egen totssi21=rowtotal(fedpmt_526_0-fedpmt_546_0)
	egen totssimiss21=rowtotal(fedpmt_526_0-fedpmt_546_0), missing

	gen anyssi21=(totssi21>0)
	gen anyssimiss21=(totssi21>0) if !missing(totssimiss21)
	
	egen avessi21=rowmean(fedpmt_526_0-fedpmt_546_0)
	
	egen numssi21=rownonmiss(fedpmt_526_0-fedpmt_546_0)
	gen numssimiss21=numssi21 if numssi21~=0
			
		
	egen totssi24=rowtotal(fedpmt_526_0-fedpmt_549_0)
	egen totssimiss24=rowtotal(fedpmt_526_0-fedpmt_549_0), missing

	gen anyssi24=(totssi24>0)
	gen anyssimiss24=(totssi24>0) if !missing(totssimiss24)
	
	egen avessi24=rowmean(fedpmt_526_0-fedpmt_549_0)
	
	egen numssi24=rownonmiss(fedpmt_526_0-fedpmt_549_0)
	gen numssimiss24=numssi24 if numssi24~=0	
	
	
gen time_doe=2017-year(bclm_doe_start_1)
	gen time_group=.
		replace time_group=0 if time_doe<3
		replace time_group=1 if inrange(time_doe,3,5)
		replace time_group=2 if inrange(time_doe,6,10)
		replace time_group=3 if inrange(time_doe,11,15)
		replace time_group=4 if time_doe>15

destring dib_dig_1, gen(dibdig) 
gen conditions=""
	replace conditions="01 Infectious and Parasitic" /*"17 Other"*/ if inrange(dibdig,0020,0189) | inrange(dibdig,0200,0279) | inrange(dibdig,0300,0419) | ///
			inrange(dibdig,0430,0579) | inrange(dibdig,0600,0669) | inrange(dibdig,0700,0889) | inrange(dibdig,0900,1049) | ///
			inrange(dibdig,1100,1189) | inrange(dibdig,1200,1359) |  inrange(dibdig,1370,1399) | inrange(dibdig,7710,7719)
	replace conditions="02 Neoplasms" if inrange(dibdig,0420,0429) | inrange(dibdig,1400,1659) | inrange(dibdig,1700,1769) | ///
			inrange(dibdig,1780,2089) | inrange(dibdig,2100,2399)
	replace conditions="03 Endocrine" if inrange(dibdig,2400,2469) | inrange(dibdig,2500,2539) | inrange(dibdig,2550,2559) | ///
			inrange(dibdig,2600,2799)
	replace conditions="04 Blood" if inrange(dibdig,2800,2899) | inrange(dibdig,7720,7739) |  inrange(dibdig,7760,7769)
	
	replace conditions="05a Autistic Disorders" if inrange(dibdig,2990,2999) 
	replace conditions="05b Developmental disorders" if inrange(dibdig,3150,3159) 	
	replace conditions="05c Childhood and adolescent disorders not elsewhere classified" if inrange(dibdig,3120,3149) 	
	replace conditions="05d Intellectual disability" if inrange(dibdig,3170,3194) | inrange(dibdig,3196,3199) 
	replace conditions="05e Mood disorders" if inrange(dibdig,2960,2969) | inrange(dibdig,3110,3119) 
	replace conditions="05f Organic Mental Disorders" if inrange(dibdig,2900,2909)  | inrange(dibdig,2940,2949)  | inrange(dibdig,3100,3109) 	
	replace conditions="05g Schizophrenia" if inrange(dibdig,2950,2959) | inrange(dibdig,2970,2989) 	
	replace conditions="05h Other Mental disorders" if inrange(dibdig,2910,2939) | inrange(dibdig,3000,3099) | inrange(dibdig,3160,3169) | dibdig==3195
			
	replace conditions="08 Nervous System" if inrange(dibdig,3200,3269) | inrange(dibdig,3290,3379) | inrange(dibdig,3400,3749) | ///
			inrange(dibdig,3760,3899)
	replace conditions="09 Circulatory System" if inrange(dibdig,3750,3759) | inrange(dibdig,3900,3989) | inrange(dibdig,4010,4059) | ///
			inrange(dibdig,4100,4179) | inrange(dibdig,4200,4389) | inrange(dibdig,4400,4449) | inrange(dibdig,4460,4489) | ///
			inrange(dibdig,4510,4599)
	replace conditions="10 Respiratory System" if inrange(dibdig,4600,4669) | inrange(dibdig,4700,4789) | inrange(dibdig,4800,4879) | ///
			inrange(dibdig,4900,4969) | inrange(dibdig,5000,5089) | inrange(dibdig,5100,5199) | inrange(dibdig,7680,7709)
	replace conditions="11 Digestive System" if inrange(dibdig,5200,5379) | inrange(dibdig,5400,5439) | inrange(dibdig,5500,5539) | ///
			inrange(dibdig,5550,5589) | inrange(dibdig,5600,5609) | inrange(dibdig,5620,5629) | inrange(dibdig,5640,5799) | ///
			inrange(dibdig,7770,7779) 
	replace conditions="12 Genitourinary System" if inrange(dibdig,5800,6089) | inrange(dibdig,6100,6119) | inrange(dibdig,6140,6299)
	replace conditions="13 Skin" /*"17 Other"*/ if inrange(dibdig,6800,6869) | inrange(dibdig,6900,6989) | inrange(dibdig,7000,7099) | ///
			inrange(dibdig,7780,7789)
	replace conditions="14 Musculoskeletal" if inrange(dibdig,7100,7399)
	replace conditions="15 Congenital Anomalies" /*"17 Other"*/ if inrange(dibdig,7400,7599)
	replace conditions="16 Injuries" if inrange(dibdig,8000,8489) | inrange(dibdig,8500,8549) | inrange(dibdig,8600,8879) | ///
			inrange(dibdig,8900,8979) | inrange(dibdig,9000,9059) | inrange(dibdig,9070,9099) | inrange(dibdig,9200,9299) | ///
			inrange(dibdig,9400,9599)
	replace conditions="17 Other" if inrange(dibdig,7600,7609) | inrange(dibdig,7640,7669) | inrange(dibdig,7800,7809) | ///
			inrange(dibdig,7830,7849) | dibdig==9330
	replace conditions="18 Unknown" if dibdig==. | inrange(dibdig,0,0019) | inrange(dibdig,0190,0199) | inrange(dibdig,0280,0299) | ///
			inrange(dibdig,0580,0599) | inrange(dibdig,0670,0699) | inrange(dibdig,0890,0899) | inrange(dibdig,1050,1099) | ///
			inrange(dibdig,1190,1199) | inrange(dibdig,1360,1369) | inrange(dibdig,1660,1699) | inrange(dibdig,1770,1779) | ///
			inrange(dibdig,2090,2099) | inrange(dibdig,2470,2499) | inrange(dibdig,2540,2549) | inrange(dibdig,2560,2599) | ///
			inrange(dibdig,3270,3289) | inrange(dibdig,3380,3399) | ///
			inrange(dibdig,3990,4009) | inrange(dibdig,4060,4099) | inrange(dibdig,4180,4199) | inrange(dibdig,4390,4399) | ///
			inrange(dibdig,4450,4459) | inrange(dibdig,4490,4509) | inrange(dibdig,4670,4699) | inrange(dibdig,4790,4799) | ///
			inrange(dibdig,4880,4899) | inrange(dibdig,4970,4999) | inrange(dibdig,5090,5099) | inrange(dibdig,5380,5399) | ///
			inrange(dibdig,5440,5499) | inrange(dibdig,5540,5549) | inrange(dibdig,5590,5599) | inrange(dibdig,5610,5619) | ///
			inrange(dibdig,5630,5639) | inrange(dibdig,6090,6099) | inrange(dibdig,6120,6139) | inrange(dibdig,6300,6799) | ///
			inrange(dibdig,6870,6899) | inrange(dibdig,6990,6999) | inrange(dibdig,7610,7639) | inrange(dibdig,7670,7679) | ///
			inrange(dibdig,7790,7799) | inrange(dibdig,7810,7829) | inrange(dibdig,7850,7999) | inrange(dibdig,8490,8499) | ///
			inrange(dibdig,8550,8599) | inrange(dibdig,8880,8899) | inrange(dibdig,8980,8999) | inrange(dibdig,9060,9069) | ///
			inrange(dibdig,9100,9199) | inrange(dibdig,9300,9329) | inrange(dibdig,9331,9399) | inrange(dibdig,9600,9999) | ///
			dibdig==7740
	/*Make them numeric and label them*/
		encode conditions, gen(disab1)

gen race=racep
	replace race="M" if racep==""
	
gen reduc=erreduc
	replace reduc=2 if erreduc==.
	
gen hibasis=hi_basis
	replace hibasis="M" if hi_basis==""
		/*See http://policynet.ba.ssa.gov/poms.nsf/lnx/0800850315
		A=Age 65
		B=Disability
		E=End-Stage Renal
		H=Environmental Health Hazard
		W=Working Disabled Individual*/
		
	
gen smibasis=smi_basis
	replace smibasis="M" if smi_basis==""	
	/*see http://policynet.ba.ssa.gov/poms.nsf/lnx/0800850125 same as above*/
	
gen dual=dual_type
	replace dual="NA" if dual_type==""
	
gen dual_binary=(dual~="NA")

gen dual_group=0
	replace dual_group=1 if substr(dual,1,1)=="D"
	replace dual_group=2 if substr(dual,1,1)=="R"

gen med_stat=medstat
	replace med_stat="M" if medstat==""
	/*medstat=A: Medicare active*/
	
gen redage=red_for_age
	replace redage="N" if red_for_age==""
	

gen anyletter=(treatment~=0)

gen male=(sexb=="M")

encode addr_state, gen(state)
tostring state, gen(state2)

gen potentialssi=735+20-mba

*gen prior=inlist(sisc,"B","L","N","T","U","V","W","X")
 *replace prior=1 if inlist(sisc,"I","P")
gen prior=inlist(prior_ssi_status,2,3,4)

	/*additional variables needed*/
label define treatment 0 "Control" 1 "Basic" 2 "Maximum" 3 "Simplify" 4 "Combined", replace
label values treatment treatment
	
/*Letter type*/
gen maxbenefit=inlist(treatment,2,4)
gen simplifying=inlist(treatment,3,4)

/*For heterogenous treatment effects*/
gen age_group=.
	replace age_group=0 if age==65
	replace age_group=1 if inrange(age,66,70)
	replace age_group=2 if inrange(age,71,75)
	replace age_group=3 if inrange(age,76,80)
tab age_group, missing gen(age_group_)

xtile potentialquint=potentialssi, n(5)
tab potentialquint, gen(quint_)

gen potentialssi_old=potentialssi
drop potentialssi
gen potentialssi=potentialssi_old/1000

gen state209=inlist(addr_state,"CT","HI","IL","MN","MO","NH","ND","OK","VA")
gen statessi=inlist(addr_state,"AK","ID","KS","NE","NV","OR","UT")
gen medicaid=(state209==0 & statessi==0)
gen state_group=.
	replace state_group=0 if medicaid==1
	replace state_group=1 if state209==1
	replace state_group=2 if statessi==1
	
gen wepgpo=(wep_ind==1 | gpo_ind==1)
	
	/*http://policynet.ba.ssa.gov/poms.nsf/lnx/0501715010*/
	

	/*already have an indicate of BIC=a--"bica"*/
capture drop bentype
gen bentype=.
replace bentype=1 if bic=="A"
replace bentype=2 if substr(bic,1,1)=="B"
replace bentype=3 if substr(bic,1,1)=="C"
replace bentype=4 if substr(bic,1,1)=="D"
replace bentype=5 if substr(bic,1,1)=="E"
replace bentype=6 if substr(bic,1,1)=="F"
replace bentype=7 if substr(bic,1,1)=="W"

tab bentype, missing
label define bentype 1 "Worker" 2 "Spouse" 3 "Child" 4 "Widow" 5 "Young Widow" 6 "Parent" 7 "Disabled Widow", replace
label values bentype bentype

capture drop bentype2
gen bentype2=0
replace bentype2=1 if bic=="A"
replace bentype2=2 if substr(bic,1,1)=="B"
replace bentype2=4 if substr(bic,1,1)=="D"

tab bentype2, missing
label define bentype2 1 "Worker" 2 "Spouse" 4 "Widow" 0 "Other", replace
label values bentype2 bentype2
tab bentype2, gen(bentype_)


	/*earnings*/
gen anyearn1=(earn2016>0 & !missing(earn2016))
gen anyearn2=(earn2015>0 & !missing(earn2015))
gen anyearn3=(earn2014>0 & !missing(earn2014))
gen anyearn4=(earn2013>0 & !missing(earn2013))
gen anyearn5=(earn2012>0 & !missing(earn2012))

gen anyearn_last5=anyearn1+anyearn2+anyearn3+anyearn4+anyearn5
	replace anyearn_last5=1 if anyearn_last5>0
gen anyearn_last2=anyearn1+anyearn2
	replace anyearn_last2=1 if anyearn_last2>0

gen earn_inelig=(earn2016>18372 & !missing(earn2016))
gen inelig=((potentialssi_old-(.5*(earn2016/12) - 65))<0)

label define treatment 0 "Control" 1 "Basic" 2 "Maximum" 3 "Simplify" 4 "Combined", replace
label values treatment treatment
label define age_group 0 "65" 1 "66 to 70" 2 "71 to 75" 3 "76 to 80", replace
label values age_group age_group

compress
save outcomes06012022b, replace

	/*add in ZIP demographics*/
clear
import delimited using "ACSDP5Y2017.DP05_data_with_overlays_2022-05-16T194631.csv", varnames(1) rowrange(3:)
split name, p(" ")
rename name2 addr_zip
order geo_id name addr_zip
keep addr_zip dp05_0064pe dp05_0065pe
rename dp05_0064pe zip_white
rename dp05_0065pe zip_black
sort addr_zip
compress
save zip_race, replace


use outcomes06012022b, clear
sort addr_zip
merge m:1 addr_zip using zip_race, gen(zmerge)

destring zip_white, gen(zip_white_n) ignore("-")
gen zip_nw=100-zip_white_n
gen zip_nw_ind=(zip_nw==.)
egen zip_nw_mean=mean(zip_nw)
replace zip_nw=zip_nw_mean if zip_nw_ind==1.

gen min50_zip=(zip_nw>50) 
gen min33_zip=(zip_nw>33.3)
gen min25_zip=(zip_nw>25) 


label define treatment 0 "Control" 1 "Basic" 2 "Maximum" 3 "Simplify" 4 "Combined", replace
label values treatment treatment
label define age_group 0 "65" 1 "66 to 70" 2 "71 to 75" 3 "76 to 80", replace
label values age_group age_group


	/*Denials*/
gen applied528=applied3
gen applied531=applied6
gen applied534=applied9
gen applied537=applied12
gen applied540=applied15
gen applied543=applied18
gen applied546=applied21
gen applied549=applied24

gen awarded528=awarded3
gen awarded531=awarded6
gen awarded534=awarded9
gen awarded537=awarded12
gen awarded540=awarded15
gen awarded543=awarded18
gen awarded546=awarded21
gen awarded549=awarded24


replace pstat_528="" if inlist(pstat_528,"T51","T31")
replace pstat_531="" if inlist(pstat_531,"T51","T31")
replace pstat_534="" if inlist(pstat_534,"T51","T31")
replace pstat_537="" if inlist(pstat_537,"T51","T31")
replace pstat_540="" if inlist(pstat_540,"T51","T31")
replace pstat_543="" if inlist(pstat_543,"T51","T31")
replace pstat_546="" if inlist(pstat_546,"T51","T31")
replace pstat_549="" if inlist(pstat_549,"T51","T31")

replace pstat_531=pstat_528 if pstat_531==""
replace pstat_534=pstat_531 if pstat_534==""
replace pstat_537=pstat_534 if pstat_537==""
replace pstat_540=pstat_537 if pstat_540==""
replace pstat_543=pstat_540 if pstat_543==""
replace pstat_546=pstat_543 if pstat_546==""
replace pstat_549=pstat_546 if pstat_549==""

forvalues m=528(3)549 {
	capture drop denied`m'
	gen denied`m'=.
		replace denied`m'=0 if applied`m'==1 & awarded`m'~=1
		replace denied`m'=1 if applied`m'==1 & inlist(pstat_`m',"N01","N04") /*income or resources*/
		replace denied`m'=2 if applied`m'==1 & inlist(pstat_`m',"N02","N03","N13","N23","N24","N25") /*outside US or institutionalized, convicted, etc.*/
		replace denied`m'=3 if applied`m'==1 & inlist(pstat_`m',"N05","N06","N12","N17","N18","N19","N20") /*can"t determine eligibility, not filing for other benefits,withdrew, not pursued, FTC, voluntarily ended*/
		replace denied`m'=4 if applied`m'==1 & inlist(pstat_`m',"S06","S07") /*Suspense--address issue or returned check*/
		replace denied`m'=5 if applied`m'==1 & inlist(pstat_`m',"T01") /*death*/
		replace denied`m'=6 if applied`m'==1 & inlist(pstat_`m',"T33","T50") /*record full*/
		replace denied`m'=7 if applied`m'==1 & inlist(pstat_`m',"T31","T51") /*General Termination, no more records*/
		replace denied`m'=8 if applied`m'==1 & inlist(substr(pstat_`m',1,1),"E","H")
		replace denied`m'=9 if awarded`m'==1 | inlist(substr(pstat_`m',1,1),"C","M")
		replace denied`m'=10 if applied`m'==0


	label define denied 0 "No Decision" 1 "Income/Resources" 2 "Other Eligibility" ///
		3 "Misc Reasons" 4 "Suspense" 5 "Death" 6 "Record Full" 7 "General" 8 "Hold or Nopay" 9 "Awarded" 10 "No Application", replace
	label values denied`m' denied

	capture drop deny`m'
	capture drop denycond`m'
gen deny`m'=inrange(denied`m',1,7)
gen denycond`m'=inrange(denied`m',1,7) if inrange(denied`m',0,9)
}

rename denied528 denied3
rename denied531 denied6
rename denied534 denied9
rename denied537 denied12
rename denied540 denied15
rename denied543 denied18
rename denied546 denied21
rename denied549 denied24

rename deny528 deny3
rename deny531 deny6
rename deny534 deny9
rename deny537 deny12
rename deny540 deny15
rename deny543 deny18
rename deny546 deny21
rename deny549 deny24

rename denycond528 denycond3
rename denycond531 denycond6
rename denycond534 denycond9
rename denycond537 denycond12
rename denycond540 denycond15
rename denycond543 denycond18
rename denycond546 denycond21
rename denycond549 denycond24

	/*Denial Statistics*/

replace denied3=3 if inlist(denied3,3,4,5,6,7)
replace denied6=3 if inlist(denied6,3,4,5,6,7)
replace denied9=3 if inlist(denied9,3,4,5,6,7)
replace denied12=3 if inlist(denied12,3,4,5,6,7)
replace denied15=3 if inlist(denied15,3,4,5,6,7)
replace denied18=3 if inlist(denied18,3,4,5,6,7)
replace denied21=3 if inlist(denied21,3,4,5,6,7)
replace denied24=3 if inlist(denied24,3,4,5,6,7)

tab denied3, gen(denied3_) label
tab denied6, gen(denied6_) label
tab denied9, gen(denied9_) label
tab denied12, gen(denied12_) label
tab denied15, gen(denied15_) label
tab denied18, gen(denied18_) label
tab denied21, gen(denied21_) label
tab denied24, gen(denied24_) label


 /*denial code using dencde*/

forvalues m=528(3)549 {
	capture drop denied`m'a
	gen denied`m'a=.
		replace denied`m'a=0 if applied`m'==1 & awarded`m'~=1
		replace denied`m'a=1 if applied`m'==1 & inlist(dencde,"N01","N04") /*income or resources*/
		replace denied`m'a=2 if applied`m'==1 & inlist(dencde,"N02","N03","N13","N23","N24","N25") /*outside US or institutionalized, convicted, etc.*/
		replace denied`m'a=3 if applied`m'==1 & inlist(dencde,"N05","N06","N12","N17","N18","N19","N20") /*can"t determine eligibility, not filing for other benefits,withdrew, not pursued, FTC, voluntarily ended*/
		replace denied`m'a=4 if applied`m'==1 & inlist(dencde,"S06","S07") /*Suspense--address issue or returned check*/
		replace denied`m'a=5 if applied`m'==1 & inlist(dencde,"T01") /*death*/
		replace denied`m'a=6 if applied`m'==1 & inlist(dencde,"T33","T50") /*record full*/
		replace denied`m'a=7 if applied`m'==1 & inlist(dencde,"T31","T51") /*General Termination, no more records*/
		replace denied`m'a=8 if applied`m'==1 & inlist(substr(dencde,1,1),"E","H")
		replace denied`m'a=9 if awarded`m'==1 | inlist(substr(dencde,1,1),"C","M")
		replace denied`m'a=10 if applied`m'==0


	label define denied 0 "No Decision" 1 "Income/Resources" 2 "Other Eligibility" ///
		3 "Misc Reasons" 4 "Suspense" 5 "Death" 6 "Record Full" 7 "General" 8 "Hold or Nopay" 9 "Awarded" 10 "No Application", replace
	label values denied`m' denied

	capture drop deny`m'a
	capture drop denycond`m'a
gen deny`m'a=inrange(denied`m'a,1,7)
gen denycond`m'a=inrange(denied`m'a,1,7) if inrange(denied`m'a,0,9)
}


rename denied528a denied3a
rename denied531a denied6a
rename denied534a denied9a
rename denied537a denied12a
rename denied540a denied15a
rename denied543a denied18a
rename denied546a denied21a
rename denied549a denied24a

rename deny528a deny3a
rename deny531a deny6a
rename deny534a deny9a
rename deny537a deny12a
rename deny540a deny15a
rename deny543a deny18a
rename deny546a deny21a
rename deny549a deny24a

rename denycond528a denycond3a
rename denycond531a denycond6a
rename denycond534a denycond9a
rename denycond537a denycond12a
rename denycond540a denycond15a
rename denycond543a denycond18a
rename denycond546a denycond21a
rename denycond549a denycond24a

	/*Denial Statistics using dencde*/

replace denied3a=3 if inlist(denied3a,3,4,5,6,7)
replace denied6a=3 if inlist(denied6a,3,4,5,6,7)
replace denied9a=3 if inlist(denied9a,3,4,5,6,7)
replace denied12a=3 if inlist(denied12a,3,4,5,6,7)
replace denied15a=3 if inlist(denied15a,3,4,5,6,7)
replace denied18a=3 if inlist(denied18a,3,4,5,6,7)
replace denied21a=3 if inlist(denied21a,3,4,5,6,7)
replace denied24a=3 if inlist(denied24a,3,4,5,6,7)

tab denied3a, gen(denied3a_) label
tab denied6a, gen(denied6a_) label
tab denied9a, gen(denied9a_) label
tab denied12a, gen(denied12a_) label
tab denied15a, gen(denied15a_) label
tab denied18a, gen(denied18a_) label
tab denied21a, gen(denied21a_) label
tab denied24a, gen(denied24a_) label



compress
save outcomes06062022_alt, replace

log close


